jQuery(function ($) {
  "use strict";
  $(document).ready(function () {

    window.isermons_update_URL = function (key, value) {
      var baseUrl = [location.protocol, '//', location.host, location.pathname].join(''),
        urlQueryString = document.location.search,
        newParam = key + '=' + value,
        params = '?' + newParam;
      // If the "search" string exists, then build params from it
      if (urlQueryString) {
        var updateRegex = new RegExp('([\?&])' + key + '[^&]*');
        var removeRegex = new RegExp('([\?&])' + key + '=[^&;]+[&;]?');
        if (typeof value == 'undefined' || value == null || value == '') { // Remove param if value is empty
          params = urlQueryString.replace(removeRegex, "$1");
          params = params.replace(/[&;]$/, "");
        }
        else if (urlQueryString.match(updateRegex) !== null) { // If param exists already, update it
          params = urlQueryString.replace(updateRegex, "$1" + newParam);
        }
        else { // Otherwise, add it to end of query string
          params = urlQueryString + '&' + newParam;
        }
      }
      return baseUrl + params;
    };
    window.isermons_find_query_arg = function () {
      var querystrings = {};
      location.search.substr(1).split("&").forEach(function (pair) {
        if (pair === "") return;
        var parts = pair.split("=");
        querystrings[parts[0]] = parts[1] && decodeURIComponent(parts[1].replace(/\+/g, " "));
      });
      return querystrings;
    }
    function isermons_load_shortcode(shortcode = '', blank = '') {
      shortcode = (shortcode === '') ? JSON.parse($('.isermons-sermon-result').attr('data-shortcode')) : shortcode;
      var attributes = isermons_find_query_arg();
      $.each(attributes, function (index, value) {
        shortcode[index] = value;
      });
      if (blank !== '') {
        shortcode[blank] = '';
      }
      shortcode.source = 'ajax';
      $.ajax({
        method: "POST",
        url: filters.root + 'isermons/sermons',
        data: JSON.stringify(shortcode),
        crossDomain: true,
        contentType: 'application/json',
        beforeSend: function (xhr) {
          xhr.setRequestHeader('X-WP-Nonce', filters.nonce);
          $('.isermons-listings-view').prepend('<div class="isermons-loader-wrap" style="display: none"><div class="isermons-loader"></div></div>');
        },
        success: function (response) {
          var container = $('.isermons-list-view');
          container.empty();
          container.html(response.shortcode);
          $('.isermons select').wrap('<div class="imi-select">');
          $('.equah').each(function () {
            $(this).find('.equah-item').matchHeight();
          });
          $('.equah1').each(function () {
            $(this).find('.equah-item1').matchHeight();
          });
          $('.isermons-loader-wrap').remove();
          $(document).on('click', '.isermons-dl-files > a', function (e) {
            $('ul.isermons-download-files').fadeOut();
            $(this).parent('.isermons-dl-files').find('ul.isermons-download-files').fadeToggle();
            e.preventDefault();
          });
          $(document).on('click', function (evt) {
            if ($(evt.target).closest('.isermons-dl-files').length) {

            } else {
              $('ul.isermons-download-files').fadeOut();
            }

          });
        },
        error: function (response) {

        }
      });
    }
    window.onpopstate = function (event) {
      isermons_load_shortcode();
    };
    $(document).on('change', '.isermons-filter-sermons', function () {
      var selected = ($(this).hasClass('isermons-btn-primary')) ? $(this).closest('div').find('input') : $(this).find('option:selected');
      var shortcode = JSON.parse($(this).closest('.isermons-list-view').find('.isermons-sermon-result').attr('data-shortcode'));
      var attribute = $(this).attr('data-attr');
      var new_val = selected.val();
      new_val = (new_val === '') ? null : new_val;
      var nattribute = (new_val === null) ? attribute : '';
      history.pushState('', '', isermons_update_URL(attribute, new_val));
      isermons_load_shortcode(shortcode, nattribute);
    });
    $(document).on('click', '.isermons-filter-sermons-search', function () {
      var selected = ($(this).hasClass('isermons-btn-primary')) ? $(this).closest('div').find('input') : $(this).find('option:selected');
      var shortcode = JSON.parse($(this).closest('.isermons-list-view').find('.isermons-sermon-result').attr('data-shortcode'));
      var attribute = $(this).attr('data-attr');
      var new_val = selected.val();
      new_val = (new_val === '') ? null : new_val;
      var nattribute = (new_val === null) ? attribute : '';
      history.pushState('', '', isermons_update_URL(attribute, new_val));
      isermons_load_shortcode(shortcode, nattribute);
    });
    $(document).on('change', '.isermons-tabs-input', function () {
      var tab = $(this).val();
      history.pushState('', '', isermons_update_URL('tabs', tab));
    });
  });
});