<?php
defined( 'ABSPATH' ) or die( 'No script kiddies please!' );
if(!function_exists('isermons_enqueue_admin_scripts'))
{
	/*
	* Enqueue the style and js for back end
	*/
	function isermons_enqueue_admin_scripts($hook) {
		$pages = get_pages();
        $colorpicker = '';
		$list_pages = array();
		foreach ( $pages as $page )
		{
			$list_pages[] = array('label'=>$page->post_title, 'value'=>$page->ID);
		}
        if(isset($_REQUEST['taxonomy']) && ($_REQUEST['taxonomy']=='imi_isermons-categories' || $_REQUEST['taxonomy']=='imi_isermons-series' || $_REQUEST['taxonomy']=='imi_isermons-topics' || $_REQUEST['taxonomy']=='imi_isermons-books' || $_REQUEST['taxonomy']=='imi_isermons-preachers')){
				wp_enqueue_media();
		}
        if(isset($_REQUEST['page'])=='isermons_settings_options')
		{
			wp_enqueue_script('wp-color-picker');
			wp_enqueue_style('wp-color-picker');
            $colorpicker = 1;
		}
		wp_enqueue_script( 'jquery-ui-datepicker' );
		wp_enqueue_script( 'jquery-ui-autocomplete' );
		wp_enqueue_script( 'isermons-admin-scripts', ISERMONS__PLUGIN_URL . 'js/admin_scripts.js', array('jquery'), '', true);
		wp_localize_script('isermons-admin-scripts', 'isermons', array('pages'=>$list_pages, 'ajax_url' => admin_url( 'admin-ajax.php' ),'root' => esc_url_raw( rest_url() ), 'nonce' => wp_create_nonce( 'wp_rest' ), 'color'=>$colorpicker));
		wp_enqueue_style( 'isermons-admin-style', ISERMONS__PLUGIN_URL . 'css/admin_style.css');
        wp_enqueue_style( 'jquery-ui', ISERMONS__PLUGIN_URL . 'css/smoothness-jquery-ui.css' );
        wp_enqueue_style('eventer_ui_css',ISERMONS__PLUGIN_URL . 'css/themes-jquery-ui.css',false,"1.9.0",false);

	}
	add_action( 'admin_enqueue_scripts', 'isermons_enqueue_admin_scripts' );
}

add_action( 'after_setup_theme', 'isermons_theme_setup' );
 
if ( ! function_exists( 'isermons_theme_setup' ) ) {
	function isermons_theme_setup(){
		/********* Registers an editor stylesheet for the theme ***********/
		add_action( 'admin_init', 'isermons_theme_add_editor_styles' );
		/********* TinyMCE Buttons ***********/
		add_action( 'init', 'isermons_buttons' );
	}
}

/********* Registers an editor stylesheet for the theme ***********/
if ( ! function_exists( 'isermons_theme_add_editor_styles' ) ) {
	function isermons_theme_add_editor_styles() {
	    add_editor_style( 'custom-editor-style.css' );
	}
}
 
/********* TinyMCE Buttons ***********/
if ( ! function_exists( 'isermons_buttons' ) ) {
	function isermons_buttons() {
		if ( ! current_user_can( 'edit_posts' ) && ! current_user_can( 'edit_pages' ) ) {
	        return;
	    }
 
	    if ( get_user_option( 'rich_editing' ) !== 'true' ) {
	        return;
	    }
 
	    add_filter( 'mce_external_plugins', 'isermons_add_buttons' );
	    add_filter( 'mce_buttons', 'isermons_register_buttons' );
	}
}
 
if ( ! function_exists( 'isermons_add_buttons' ) ) {
	function isermons_add_buttons( $plugin_array ) {
	    $plugin_array['isermons'] = ISERMONS__PLUGIN_URL.'js/tinymce_buttons.js';
	    return $plugin_array;
	}
}
 
if ( ! function_exists( 'isermons_register_buttons' ) ) {
	function isermons_register_buttons( $buttons ) {
	    array_push( $buttons, 'isermons' );
	    return $buttons;
	}
}

function isermons_generate_shortcode()
{
	$series = isermons_get_terms_front('imi_isermons-series');
	$categories = isermons_get_terms_front('imi_isermons-categories');
	$books = isermons_get_terms_front('imi_isermons-books');
	$topics = isermons_get_terms_front('imi_isermons-topics');
	$preachers = isermons_get_terms_front('imi_isermons-preachers');
	$taxonomies = array(esc_html__('Categories', 'isermons')=>$categories, esc_html__('Series', 'isermons')=>$series, esc_html__('Books', 'isermons')=>$books, esc_html__('Topics', 'isermons')=>$topics, esc_html__('Preachers', 'isermons')=>$preachers);
	$hide_fields = ' style="display:none;"';
	?>
	<div class="ui-sortable meta-box-sortables isermons-admin-thickbox-content">
        <div class="postbox">
            <div class="inside">
				<table class="form-table">
					<tr valign="top" class="">
						<th scope="row"><?php esc_html_e( 'Select shortcode', 'isermons' ); ?></th>
						<td>
							<select class="isermons-admin-shortcode-name">
								<option data-relate="sermon-admin-list" value="isermons-list"><?php esc_html_e('Sermon Posts', 'isermons'); ?></option>
								<option data-relate="sermon-admin-series" value="isermons-terms"><?php esc_html_e('Sermon Taxonomy', 'isermons'); ?></option>
							</select>
							<p class="description"><?php esc_html_e('Select the shortcode which you want to generate.', 'isermons'); ?></p>
						</td>
					</tr>
					
					<tr valign="top" class="sermon-admin-list isermons-shortcode-fields">
						<th scope="row"><?php esc_html_e( 'Style', 'isermons' ); ?></th>
						<td>
							<select class="isermons-admin-shortcode-fields" data-short="layout">
								<option value="classic"><?php esc_html_e('Classic', 'isermons'); ?></option>
								<option value="minimal"><?php esc_html_e('Minimal', 'isermons'); ?></option>
								<option value="grid"><?php esc_html_e('Grid', 'isermons'); ?></option>
							</select>
							<p class="description"><?php esc_html_e('Select the layout that you want to use for sermons.', 'isermons'); ?></p>
						</td>
					</tr>
					
                    
                    <tr valign="top" class="sermon-admin-list isermons-shortcode-fields">
						<th scope="row"><?php esc_html_e( 'Relate with', 'isermons' ); ?></th>
						<td>
							<select class="isermons-admin-shortcode-fields" data-short="relation">
								<option value="categories"><?php esc_html_e('Current post category', 'isermons'); ?></option>
								<option value="series"><?php esc_html_e('Current post series', 'isermons'); ?></option>
								<option value="books"><?php esc_html_e('Current post books', 'isermons'); ?></option>
                                <option value="topics"><?php esc_html_e('Current post topics', 'isermons'); ?></option>
                                <option value="preachers"><?php esc_html_e('Current post preachers', 'isermons'); ?></option>
							</select>
							<p class="description"><?php esc_html_e('Select the taxonomy to show related sermons at sermon details page.', 'isermons'); ?></p>
						</td>
					</tr>
                    
					<tr valign="top" class="sermon-admin-series isermons-shortcode-fields sermon-admin-term-imi_isermons-categories  sermon-admin-term-imi_isermons-topics  sermon-admin-term-imi_isermons-books  sermon-admin-term-imi_isermons-series  sermon-admin-term-imi_isermons-preachers isermons-taxonomy-shortcode-fields" <?php echo wp_kses($hide_fields, isermons_allowed_html()); ?>>
						<th scope="row"><?php esc_html_e( 'Style', 'isermons' ); ?></th>
						<td>
							<select class="isermons-admin-shortcode-fields" data-short="layout">
								<option value="style1"><?php esc_html_e('Grid style1', 'isermons'); ?></option>
								<option value="style2"><?php esc_html_e('Grid style2', 'isermons'); ?></option>
								<option value="style"><?php esc_html_e('List', 'isermons'); ?></option>
							</select>
							<p class="description"><?php esc_html_e('Select the layout which you want to use for terms.', 'isermons'); ?></p>
						</td>
					</tr>
					
					<tr valign="top" class="sermon-admin-list isermons-shortcode-fields">
						<th scope="row"><?php esc_html_e( 'Search & Sort', 'isermons' ); ?></th>
						<td>
                            <label>
                            <input type="checkbox" class="isermons-admin-shortcode-fields isermons-admin-selectall" name="search" data-short="search" value="all">
                            <?php esc_html_e('All', 'isermons'); ?>
							
                            </label><br/>
							<label>
                            <input type="checkbox" class="isermons-admin-shortcode-fields" name="search" data-short="search" value="keyword">
                            <?php esc_html_e('Keyword', 'isermons'); ?>
							
                            </label><br/>
							<label>
                            <input type="checkbox" name="search" value="year">
                            <?php esc_html_e('Years', 'isermons'); ?>
							
                            </label><br/>
							<label>
                            <input type="checkbox" name="search" value="order">
                            <?php esc_html_e('Order', 'isermons'); ?>
							
                            </label><br/>
							<p class="description"><?php esc_html_e('Select fields for search and sort area.', 'isermons'); ?></p>
						</td>
					</tr>
                    
                    
					
					<tr valign="top" class="sermon-admin-list isermons-shortcode-fields">
						<th scope="row"><?php esc_html_e( 'Filters', 'isermons' ); ?></th>
						<td>
                            <label>
							<input type="checkbox" class="isermons-admin-shortcode-fields isermons-admin-selectall" name="filters" data-short="filters" value="all">
                            <?php esc_html_e('All', 'isermons'); ?>
                            </label><br/>
							<label>
							<input type="checkbox" class="isermons-admin-shortcode-fields" name="filters" data-short="filters" value="series">
                            <?php esc_html_e('Series', 'isermons'); ?>
                            </label><br/>
							<label>
							<input type="checkbox" name="filters" value="categories">
                            <?php esc_html_e('Categories', 'isermons'); ?>
                            </label><br/>
							<label>
							<input type="checkbox" name="filters" value="books">
                            <?php esc_html_e('Books', 'isermons'); ?>
                            </label><br/>
							<label>
							<input type="checkbox" name="filters" value="topics">
                            <?php esc_html_e('Topics', 'isermons'); ?>
                            </label><br/>
							<label>
							<input type="checkbox" name="filters" value="preachers">
                            <?php esc_html_e('Preachers', 'isermons'); ?>
                            </label><br/>
							<p class="description"><?php esc_html_e('Select taxonomies for search and filter area.', 'isermons'); ?></p>
						</td>
					</tr>
					
					<!--<tr valign="top" class="sermon-admin-list isermons-shortcode-fields">
						<th scope="row"><?php esc_html_e( 'Filters Operator', 'isermons' ); ?></th>
						<td>
							<select class="isermons-admin-shortcode-fields" data-short="filters_operator">
								<option value="AND"><?php esc_html_e('And', 'isermons'); ?></option>
								<option value="OR"><?php esc_html_e('OR', 'isermons'); ?></option>
							</select>
							<p class="description"><?php esc_html_e('Select the operator for filters, Ex-{And} filter will sort all terms to show matching from previously selected values.', 'isermons'); ?></p>
						</td>
					</tr>-->
                    
                    <tr valign="top" class="sermon-admin-list isermons-shortcode-fields">
						<th scope="row"><?php esc_html_e( 'Watch sermon', 'isermons' ); ?></th>
						<td>
							<input type="text" value="<?php esc_html_e('Watch sermon', 'isermons'); ?>" class="isermons-admin-shortcode-fields" data-short="watch">
							<p class="description"><?php esc_html_e('Replace text for watch sermon button.', 'isermons'); ?></p>
						</td>
					</tr>
                    
                    <tr valign="top" class="sermon-admin-series isermons-shortcode-fields sermon-admin-term-imi_isermons-categories  sermon-admin-term-imi_isermons-topics  sermon-admin-term-imi_isermons-books  sermon-admin-term-imi_isermons-series  sermon-admin-term-imi_isermons-preachers isermons-taxonomy-shortcode-fields">
						<th scope="row"><?php esc_html_e( 'Excerpt length', 'isermons' ); ?></th>
						<td>
							<input type="text" value="25" class="isermons-admin-shortcode-fields" data-short="words">
							<p class="description"><?php esc_html_e('Enter the number of words to show for term description.', 'isermons'); ?></p>
						</td>
					</tr>
                    
                    <!--<tr valign="top" class="sermon-admin-list isermons-shortcode-fields">
						<th scope="row"><?php esc_html_e( 'Image hover', 'isermons' ); ?></th>
						<td>
							<select class="isermons-admin-shortcode-fields" data-short="hover">
								<option value="enable"><?php esc_html_e('Enable', 'isermons'); ?></option>
								<option value="disable"><?php esc_html_e('Disable', 'isermons'); ?></option>
							</select>
							<p class="description"><?php esc_html_e('Enable/Disable hover effect on image.', 'isermons'); ?></p>
						</td>
					</tr>-->
					
					<tr valign="top" class="sermon-admin-series isermons-shortcode-fields sermon-admin-term-imi_isermons-categories  sermon-admin-term-imi_isermons-topics  sermon-admin-term-imi_isermons-books  sermon-admin-term-imi_isermons-series  sermon-admin-term-imi_isermons-preachers isermons-taxonomy-shortcode-fields">
						<th scope="row"><?php esc_html_e( 'Grid column', 'isermons' ); ?></th>
						<td>
							<select class="isermons-admin-shortcode-fields" data-short="columns">
								<option value="4"><?php esc_html_e('Four', 'isermons'); ?></option>
								<option value="3"><?php esc_html_e('Three', 'isermons'); ?></option>
								<option value="2"><?php esc_html_e('Two', 'isermons'); ?></option>
								<option value="1"><?php esc_html_e('One', 'isermons'); ?></option>
							</select>
							<p class="description"><?php esc_html_e('Select columns for grid layout.', 'isermons'); ?></p>
						</td>
					</tr>
                    
                    <tr valign="top" class="isermons-shortcode-fields sermon-admin-series sermon-admin-list sermon-admin-term-imi_isermons-categories  sermon-admin-term-imi_isermons-topics  sermon-admin-term-imi_isermons-books  sermon-admin-term-imi_isermons-series  sermon-admin-term-imi_isermons-preachers isermons-taxonomy-shortcode-fields">
						<th scope="row"><?php esc_html_e( 'Image size', 'isermons' ); ?></th>
						<td>
							<select class="isermons-admin-shortcode-fields" data-short="image">
                                <?php
                                global $_wp_additional_image_sizes;
                                foreach($_wp_additional_image_sizes as $key=>$value)
                                {
                                    echo '<option value="'.esc_attr($key).'">'.esc_attr($value['width'].'X'.$value['height']).'</option>';
                                }
                                ?>
							</select>
							<p class="description"><?php esc_html_e('Select image size, these are the all thumbnail sizes which current theme and plugins added.', 'isermons'); ?></p>
						</td>
					</tr>
					
					<tr valign="top" class="sermon-admin-series isermons-shortcode-fields" <?php echo wp_kses($hide_fields, isermons_allowed_html()); ?>>
						<th scope="row"><?php esc_html_e( 'Select taxonomy', 'isermons' ); ?></th>
						<td>
							<select class="isermons-admin-shortcode-name isermons-admin-shortcode-fields" data-short="taxonomy">
                                <option data-relate="isermons-taxonomy-shortcode-fields" value=""><?php esc_html_e('Select', 'isermons'); ?></option>
								<option data-relate="sermon-admin-term-imi_isermons-categories" value="imi_isermons-categories"><?php esc_html_e('Sermon Categories', 'isermons'); ?></option>
								<option data-relate="sermon-admin-term-imi_isermons-series" value="imi_isermons-series"><?php esc_html_e('Sermon Series', 'isermons'); ?></option>
								<option data-relate="sermon-admin-term-imi_isermons-books" value="imi_isermons-books"><?php esc_html_e('Sermon Books', 'isermons'); ?></option>
								<option data-relate="sermon-admin-term-imi_isermons-topics" value="imi_isermons-topics"><?php esc_html_e('Sermon Topics', 'isermons'); ?></option>
								<option data-relate="sermon-admin-term-imi_isermons-preachers" value="imi_isermons-preachers"><?php esc_html_e('Sermon Preachers', 'isermons'); ?></option>
							</select>
							<p class="description"><?php esc_html_e('Select the taxonomy to show terms.', 'isermons'); ?></p>
						</td>
					</tr>
                    
                    <tr valign="top" class="sermon-admin-list isermons-shortcode-fields">
						<th scope="row"><?php esc_html_e( 'Sermons per page', 'isermons' ); ?></th>
						<td>
							<select class="isermons-admin-shortcode-fields" data-short="per_page">
                                <?php
                                for($count=1; $count<=50; $count++)
                                {
                                    echo '<option value="'.esc_attr($count).'">'.esc_attr($count).'</option>';
                                }
                                ?>
								
							</select>
							<p class="description"><?php esc_html_e('Select the number of sermons to show per page.', 'isermons'); ?></p>
						</td>
					</tr>
                    
                    <tr valign="top" class="sermon-admin-list isermons-shortcode-fields">
						<th scope="row"><?php esc_html_e( 'Show Pagination?', 'isermons' ); ?></th>
						<td>
							<select class="isermons-admin-shortcode-fields" data-short="pagination">
                                <option value="yes"><?php esc_html_e('Yes', 'isermons'); ?></option>
                                <option value="no"><?php esc_html_e('No', 'isermons'); ?></option>
							</select>
							<p class="description"><?php esc_html_e('Select no to hide pagination.', 'isermons'); ?></p>
						</td>
					</tr>
                    
                    <tr valign="top" class="sermon-admin-list isermons-shortcode-fields">
						<th scope="row"><?php esc_html_e( 'Redirect to details page', 'isermons' ); ?></th>
						<td>
							<select class="isermons-admin-shortcode-fields" data-short="redirect">
                                <option value="yes"><?php esc_html_e('Yes', 'isermons'); ?></option>
                                <option value="no"><?php esc_html_e('No', 'isermons'); ?></option>
							</select>
							<p class="description"><?php esc_html_e('Select no to block redirection of sermons to their details page.', 'isermons'); ?></p>
						</td>
					</tr>
					
					<tr valign="top" class="sermon-admin-list isermons-shortcode-fields">
						<th scope="row"><?php esc_html_e( 'Meta Data', 'isermons' ); ?></th>
						<td>
                            <label>
							<input type="checkbox" class="isermons-admin-shortcode-fields isermons-admin-selectall" name="meta_data" data-short="meta_data" value="al">
                            <?php esc_html_e('All', 'isermons'); ?>
                            </label><br/>
							<label>
							<input type="checkbox" class="isermons-admin-shortcode-fields" name="meta_data" data-short="meta_data" value="preacher">
                            <?php esc_html_e('Preacher', 'isermons'); ?>
                            </label><br/>
                            <label>
							<input type="checkbox" name="meta_data" value="books">
                            <?php esc_html_e('Books', 'isermons'); ?>
                            </label><br/>
                            <label>
							<input type="checkbox"name="meta_data" value="topics">
                            <?php esc_html_e('Topics', 'isermons'); ?>
                            </label><br/>
                            <label>
							<input type="checkbox" name="meta_data" value="categories">
                            <?php esc_html_e('Categories', 'isermons'); ?>
                            </label><br/>
							<label>
							<input type="checkbox" name="meta_data" value="date">
                            <?php esc_html_e('Date', 'isermons'); ?>
                            </label><br/>
							<label>
							<input type="checkbox" name="meta_data" value="series">
                            <?php esc_html_e('Series', 'isermons'); ?>
                            </label><br/>
							<label>
							<input type="checkbox" name="meta_data" value="chapter">
                            <?php esc_html_e('Chapter', 'isermons'); ?>
                            </label><br/>
							<label>
							<input type="checkbox" name="meta_data" value="video">
                            <?php esc_html_e('Video', 'isermons'); ?>
                            </label><br/>
							<label>
							<input type="checkbox" name="meta_data" value="audio">
                            <?php esc_html_e('Audio', 'isermons'); ?>
                            </label><br/>
							<label>
							<input type="checkbox" name="meta_data" value="download">
                            <?php esc_html_e('Download', 'isermons'); ?>
                            </label><br/>
							<p class="description"><?php esc_html_e('Select meta data for sermons.', 'isermons'); ?></p>
						</td>
					</tr>
					
					<?php
					foreach($taxonomies as $label=>$taxo)
					{
						foreach($taxo as $key=>$value)
						{
							if(empty($value)) continue;
					?>
					<tr valign="top" class="sermon-admin-list isermons-shortcode-fields">
						<th scope="row"><?php esc_html_e( 'Select ', 'isermons' ); echo esc_attr($label); ?></th>
						<td>
							<select class="isermons-admin-shortcode-fields" data-short="<?php echo esc_attr($key); ?>" multiple="multiple">
                            
								<?php foreach($value as $term)
								{
								?>
								<option value="<?php echo esc_attr($term['id']); ?>"><?php echo esc_attr($term['name']); ?></option>
								<?php
								}
								?>
							</select>
							<p class="description"><?php esc_html_e('Select terms to show sermons only from selected one.', 'isermons'); ?></p>
						</td>
					</tr>
					<?php }
					} ?>
					
					<?php
					foreach($taxonomies as $label=>$taxo)
					{
						foreach($taxo as $key=>$value)
						{
							if(empty($value)) continue;
					?>
					<tr valign="top" class="sermon-admin-term-<?php echo esc_attr($key); ?> isermons-shortcode-fields" <?php echo wp_kses($hide_fields, isermons_allowed_html()); ?>>
						<th scope="row"><?php esc_html_e( 'Select ', 'isermons' ); echo esc_attr($label); ?></th>
						<td>
							<div class="row">
								<div class="column">
									<select class="isermons-admin-shortcode-fields isermons_admin_list" data-short="<?php echo esc_attr($key); ?>">
										<option value=""><?php esc_html_e('Select', 'isermons'); ?></option>
									<?php foreach($value as $term)
									{
									?>
										<option value="<?php echo esc_attr($term['id']); ?>"><?php echo esc_attr($term['name']); ?></option>
									<?php
									}
									?>
									</select>
								</div>
								
							</div>
                            <div class="isermons-admin-enabled-area">
								</div>
							<p class="description"><?php esc_html_e('Select terms to show sermons only from selected one.', 'isermons'); ?></p>
						</td>
						<input type="hidden" class="isermons-admin-shortcode-fields" value="" data-short="custom_order_term">
					</tr>
					<?php }
					} ?>
					
					
					<tr valign="top" class="sermon-admin-series isermons-shortcode-fields sermon-admin-term-imi_isermons-categories  sermon-admin-term-imi_isermons-topics  sermon-admin-term-imi_isermons-books  sermon-admin-term-imi_isermons-series  sermon-admin-term-imi_isermons-preachers isermons-taxonomy-shortcode-fields" <?php echo wp_kses($hide_fields, isermons_allowed_html()); ?>>
						<th scope="row"><?php esc_html_e( 'Orderby', 'isermons' ); ?></th>
						<td>
							<select class="isermons-admin-shortcode-fields isermons-term-orderby" data-short="filters_order">
								<option value="id"><?php esc_html_e('ID', 'isermons'); ?></option>
								<option value="count"><?php esc_html_e('Count', 'isermons'); ?></option>
								<option value="name"><?php esc_html_e('Name', 'isermons'); ?></option>
								<option value="slug"><?php esc_html_e('Slug', 'isermons'); ?></option>
								<option value="Custom"><?php esc_html_e('Custom', 'isermons'); ?></option>
							</select>
							<p class="description"><?php esc_html_e('Select the orderby of terms.', 'isermons'); ?></p>
						</td>
					</tr>
					
					<tr valign="top">
						<th><button id="<?php echo wp_rand(1, 100); ?>" class="button button-primary isermons-admin-generate-shortcode"> <?php esc_html_e( 'Insert Shortcode', 'isermons' ); ?></button></th>
					</tr>
					
				</table>
			</div>
		</div>
	</div>
	<?php
	wp_die();
}
add_action('wp_ajax_isermons_generate_shortcode', 'isermons_generate_shortcode');

function isermons_get_terms_front($taxonomy = '', $sermon = '', $metas = array())
{
   $isermons_terms = ($sermon!='')?get_the_terms($sermon, $taxonomy):get_terms($taxonomy);
   $result = array();
   if(!is_wp_error($isermons_terms)&&!empty($isermons_terms))
   {
      foreach($isermons_terms as $term)
      {
         if(!empty($metas))
         {
            $meta_vals = array();
            foreach($metas as $meta)
            {
               $meta_vals[$meta] = get_term_meta($term->term_id, $meta, true);
            }
         }
         $result[] = array('name'=>$term->name, 'slug'=>$term->slug, 'id'=>$term->term_id, 'metas'=>$meta_vals);
      }
   }
   return array($taxonomy=>$result);
}
function isermons_data_update( $post_id ) 
{
    if(get_post_type($post_id)!='imi_isermons') return;
	$sermon_date = get_post_meta($post_id, 'isermons_date_preached', true);
    $sermon_date = ($sermon_date)?date_i18n('Y-m-d', strtotime($sermon_date)):date_i18n('Y-m-d');
    $year = (empty($sermon_date))?'':date_i18n('Y', strtotime($sermon_date));
    $saved_data = get_option('isermons_sermons_data_saved');
    $saved_data = (empty($saved_data))?array():$saved_data;
    $saved_data[$post_id] = array('preached'=>$sermon_date, 'year'=>$year);
	update_option('isermons_sermons_data_saved', $saved_data);
}
function isermons_data_update_trashed( $post_id ) 
{
    if(get_post_type($post_id)!='imi_isermons') return;
	$saved_data = get_option('isermons_sermons_data_saved');
    unset($saved_data[$post_id]);
	update_option('isermons_sermons_data_saved', $saved_data);
}
add_action( 'save_post', 'isermons_data_update', 99, 2 );
add_action( 'edit_post', 'isermons_data_update', 99, 2 );
add_action( 'publish_imi_isermons', 'isermons_data_update', 999, 2 );
add_action( 'trashed_post', 'isermons_data_update_trashed', 10, 2 );
add_action('untrash_post', 'isermons_data_update', 10, 2);

add_action('admin_enqueue_scripts', 'thickbox');
function thickbox(){
	add_thickbox();
}