<?php
/* 
 * Plugin Name: iSermons
 * Plugin URI:  https://demo1.imithemes.com/isermons
 * Description: WordPress Sermons Manager Plugin
 * Author:      imithemes
 * Version:     2.0
 * Author URI:  http://www.imithemes.com
 * Licence:     GPLv2
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 * Copyright:   (c) 2023 imithemes. All rights reserved
 * Text Domain: isermons
 * Domain Path: /languages
 */

// Do not allow direct access to this file.
defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

define( 'ISERMONS__PLUGIN_PATH', plugin_dir_path(__FILE__ ) );
define( 'ISERMONS__PLUGIN_URL', plugin_dir_url( __FILE__ ) );

/* PARTIALS ATTACHMENTS
================================================== */
require_once ISERMONS__PLUGIN_PATH . 'admin/admin_functions.php';
require_once ISERMONS__PLUGIN_PATH . 'admin/sermons-type.php';
require_once ISERMONS__PLUGIN_PATH . 'admin/settings_page.php';
require_once ISERMONS__PLUGIN_PATH . 'admin/meta_fields.php';
require_once ISERMONS__PLUGIN_PATH . 'admin/isermons_rest_endpoints.php';
require_once ISERMONS__PLUGIN_PATH . 'front/class-shortcodes.php';
require_once ISERMONS__PLUGIN_PATH . 'front/front_functions.php';
require_once ISERMONS__PLUGIN_PATH . 'front/actions.php';
require_once ISERMONS__PLUGIN_PATH . 'front/podcast-functions.php';
require_once ISERMONS__PLUGIN_PATH . 'front/REST_Endpoints.php';

/* SET LANGUAGE FILE FOLDER
=================================================== */
add_action('plugins_loaded', 'isermons_load_textdomain');
function isermons_load_textdomain() {
    load_plugin_textdomain('isermons', false, basename( dirname( __FILE__ ) ) . '/languages' );
}
// Set default settings
function isermons_get_settings( $id ) 
{
	$options = get_option( 'isermons_options' );
    if(empty($options))
    {
        update_option('isermons_options', array ( 'isermons_details_meta' => array ( 'categories',  'series',  'books',  'topics',  'preachers' ), 'isermons_details_related' => 'related', 'isermons_sermons_related_taxonomy' => '[isermons-list layout="grid" search="" filters="" filters_operator="AND" watch="Watch sermon" hover="enable" per_page="3" meta_data="preacher,date,series" imi_isermons-categories="" imi_isermons-series="" imi_isermons-books="" imi_isermons-topics="" imi_isermons-preachers="" columns="3" relation="categories"]', 'isermons_details_recent' => 'recent', 'isermons_terms_related_taxonomy' => '[isermons-terms layout="style1" columns="4" taxonomy="imi_isermons-series" imi_isermons-series="" filters_order="id"]', 'isermons_taxonomy_categories' => array ( 'categories', 'hierarchical', 'filters', 'column' ), 'isermons_taxonomy_series' => array ('series', 'hierarchical', 'column' ), 'isermons_taxonomy_books' => array ( 'books', 'hierarchical', 'column' ), 'isermons_taxonomy_topics' => array ( 'topics', 'hierarchical', 'column' ), 'isermons_taxonomy_preachers' => array ( 'preachers', 'hierarchical', 'column' ), 'isermons_sermons_archive_switch' => 'on', 'isermons_sermons_taxonomy_template' => 'on', 'isermons_enable_audio_download' => 'on', 'isermons_enable_np_links' => 'on'));
        $options = get_option( 'isermons_options' );
    }
	if ( isset( $options[$id] ) ) 
	{
		return $options[$id];
	}
}
// Custom Elementor Widgets Registration
function register_isermons_elementor_widget( $widgets_manager ) {

	require_once(ISERMONS__PLUGIN_PATH . 'elementor/class-isermons.php');
	$widgets_manager->register( new \Elementor_Isermons_Widget() );

}
add_action( 'elementor/widgets/register', 'register_isermons_elementor_widget' );