<?php
/* ==================================================
  Causes Post Type Functions
  ================================================== */
if (!defined('ABSPATH'))
    exit; // Exit if accessed directly
add_action('init', 'causes_register');

function causes_register() {
    // Permalink Structure Options
    $options = get_option('imic_options');
    // Event
    $cause_post_slug = (isset($options['cause_post_slug'])) ? $options['cause_post_slug'] : '';
    if ($cause_post_slug == '') {
        $cause_post_slug = 'causes';
    }
    $cause_post_title = (isset($options['cause_post_title'])) ? $options['cause_post_title'] : '';
    if ($cause_post_title == '') {
        $cause_post_title = 'Causes';
    }
    $cause_post_singular = (isset($options['cause_post_singular'])) ? $options['cause_post_singular'] : '';
    if ($cause_post_singular == '') {
        $cause_post_singular = 'Cause';
    }
    $cause_post_categories = (isset($options['cause_post_categories'])) ? $options['cause_post_categories'] : '';
    if ($cause_post_categories == '') {
        if ($cause_post_title != '') {
            $cause_post_categories = $cause_post_title . ' Category';
        } else {
            $cause_post_categories = 'Causes Categories';
        }
    }
    global $cause_post_payment_label;
    $cause_post_payment_label = (isset($options['cause_post_payment'])) ? $options['cause_post_payment'] : '';
    if ($cause_post_payment_label == '') {
        if ($cause_post_title != '') {
            $cause_post_payment_label = $cause_post_title . ' Payments';
        } else {
            $cause_post_payment_label = 'Causes Payments';
        }
    }
    $cause_category_slug = (isset($options['cause_category_slug'])) ? $options['cause_category_slug'] : '';
    if ($cause_category_slug == '') {
        $cause_category_slug = 'causes-category';
    }
    $cause_post_icon = (isset($options['cause_post_icon'])) ? $options['cause_post_icon'] : '';
    if ($cause_post_icon == '') {
        $cause_post_icon = 'dashicons-universal-access';
    }
    $disable_cause_archive = (isset($options['disable_cause_archive'])) ? $options['disable_cause_archive'] : 0;
    $cause_archive = $disable_cause_archive ? false : true;
    
    $args_c = array(
    "label" => $cause_post_categories,
    "singular_label" => $cause_post_title . __(' Category', "framework"),
    'public' => true,
    'hierarchical' => true,
    'show_ui' => true,
    'show_in_nav_menus' => true,
    'rewrite' => array(
        'slug' => $cause_category_slug,
        'with_front' => false
    ),
    'query_var' => true,
	'show_admin_column' => true,
);
register_taxonomy('causes-category', 'causes', $args_c);
    $labels = array(
        'name' => $cause_post_title,
        'all_items' => __('All ', 'framework') . $cause_post_title,
        'add_new' => __('Add New ', 'framework') . $cause_post_singular,
        'add_new_item' => __('Add New', 'framework') . $cause_post_singular,
        'edit_item' => __('Edit', 'framework') . $cause_post_singular,
        'new_item' => __('New', 'framework') . $cause_post_singular,
        'view_item' => __('View', 'framework') . $cause_post_singular,
        'search_items' => __('Search', 'framework').$cause_post_title,
        'not_found' => __('Nothing added yet', 'framework'),
        'not_found_in_trash' => __('Nothing found in Trash', 'framework'),
        'parent_item_colon' => '',
    );
    $args = array(
        'labels' => $labels,
        'public' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'show_in_nav_menus' => true,
        'hierarchical' => false,
		'rewrite' => array(
			'slug' => $cause_post_slug,
			'with_front' => false
		),
        'supports' => array('title', 'editor', 'thumbnail', 'comments'),
        'has_archive' => $cause_archive,
        'taxonomies' => array('causes-category'),
		'menu_icon' => $cause_post_icon,
    );
    register_post_type('causes', $args);
    register_taxonomy_for_object_type('causes-category','causes');
}
?>