<?php
/**
 * Filter Hooks
 *
 * @package hipsteria
 * @since 1.0
 */

/**
 * Post Column View
 *
 * @package hipsteria
 * @since 1.0
 */
if(!function_exists('hipsteria_posts_column_views')) {
  function hipsteria_posts_column_views($defaults) {
    $defaults['post_views'] = esc_html__('Views', 'hipsteria');
    return $defaults;
  }
  add_filter('manage_posts_columns', 'hipsteria_posts_column_views');
}

/**
 * Post Column View
 *
 * @package hipsteria
 * @since 1.0
 */
if(!function_exists('hipsteria_posts_custom_column_views')) {
  function hipsteria_posts_custom_column_views($column_name, $id) {
    if($column_name === 'post_views'){
      echo hipsteria_getPostViews(get_the_ID());
    }
  }
  add_action('manage_posts_custom_column', 'hipsteria_posts_custom_column_views',5,2);
}

/**
 * Title Filter
 *
 * @package hipsteria
 * @since 1.0
 */
if (! function_exists('hipsteria_wp_title') ) {
  function hipsteria_wp_title( $title, $sep ) {
    global $paged, $page;

    if ( is_feed() ) {
      return $title;
    } // end if

    // Add the site name.
    $title .= get_bloginfo( 'name' );

    // Add the site description for the home/front page.
    $site_description = get_bloginfo( 'description', 'display' );
    if ( $site_description && ( is_home() || is_front_page() ) ) {
      $title = "$title $sep $site_description";
    } // end if

    // Add a page number if necessary.
    if ( $paged >= 2 || $page >= 2 ) {
      $title = sprintf( __( 'Page %s', 'hipsteria' ), max( $paged, $page ) ) . " $sep $title";
    } // end if

    return $title;

  } // end rs_wp_title
  add_filter( 'wp_title', 'hipsteria_wp_title', 10, 2 );
}

/**
 * Avatar img class
 *
 * @package hipsteria
 * @since 1.0
 */
if( !function_exists('hipsteria_add_gravatar_class')) {
  function hipsteria_add_gravatar_class( $class ) {
    $class = str_replace("class='avatar", "class='media-object img-responsive img-circle", $class);
    return $class;
  }
  add_filter('get_avatar','hipsteria_add_gravatar_class');
}

/**
 * Body Filter Hook
 *
 * @package hipsteria
 * @since 1.0
 */
if( !function_exists('hipsteria_body_class')) {
  function hipsteria_body_class($classes) {
    $classes[] = hipsteria_get_opt('general-navigation-template');
    return $classes;
  }
  add_filter('body_class', 'hipsteria_body_class');
}

