<?php

$redux_opt_name = REDUX_OPT_NAME;

function hipsteria_redux_add_metaboxes($metaboxes) {

  // Variable used to store the configuration array of metaboxes
  $metaboxes = array();

  $metaboxes[] = hipsteria_redux_get_page_template_blog_metaboxes();
  $metaboxes[] = hipsteria_redux_get_page_metaboxes();
  $metaboxes[] = hipsteria_redux_get_video_post_metaboxes();
  $metaboxes[] = hipsteria_redux_get_gallery_post_metaboxes();
  $metaboxes[] = hipsteria_redux_get_post_adv_metaboxes();
  $metaboxes[] = hipsteria_redux_get_contact_metaboxes();

  return $metaboxes;
}
add_action('redux/metaboxes/'.$redux_opt_name.'/boxes', 'hipsteria_redux_add_metaboxes');


/**
 * Get configuration array for blog template
 * @return type
 */
function hipsteria_redux_get_page_template_blog_metaboxes() {

  // Variable used to store the configuration array of sections
  $sections = array();

  // Metabox used to overwrite theme options by page
  require get_template_directory() . '/framework/admin/metaboxes/blog-slider.php';
  require get_template_directory() . '/framework/admin/metaboxes/blog-featured-post.php';
  require get_template_directory() . '/framework/admin/metaboxes/blog-latest-post.php';
  require get_template_directory() . '/framework/admin/metaboxes/blog-popular-post.php';
  require get_template_directory() . '/framework/admin/metaboxes/custom-ads.php';

  return array(
    'id' => 'hipsteria-template-blog-options',
    'title' => esc_html__('Blog Options', 'hipsteria'),
    'post_types' => array('page'),
    'position' => 'normal', // normal, advanced, side
    'priority' => 'high', // high, core, default, low
    'sections' => $sections,
    'page_template' => array(
      'page-templates/blog-list.php',
      'page-templates/blog-grid.php',
    )
  );
}

/**
 * Get configuration array for contact template
 * @return type
 */
function hipsteria_redux_get_contact_metaboxes() {

  // Variable used to store the configuration array of sections
  $sections = array();

  // Metabox used to overwrite theme options by page
  require get_template_directory() . '/framework/admin/metaboxes/contact.php';

  return array(
    'id' => 'hipsteria-template-contact-options',
    'title' => esc_html__('Contact Options', 'hipsteria'),
    'post_types' => array('page'),
    'position' => 'normal', // normal, advanced, side
    'priority' => 'high', // high, core, default, low
    'sections' => $sections,
    'page_template' => array(
      'page-templates/contact.php',
    )
  );
}


/**
 * Get configuration array for page metaboxes
 * @return type
 */
function hipsteria_redux_get_page_metaboxes() {

  // Variable used to store the configuration array of sections
  $sections = array();

  // Metabox used to overwrite theme options by page
  require get_template_directory() . '/framework/admin/metaboxes/layout.php';

  return array(
    'id' => 'hipsteria-page-options',
    'title' => esc_html__('Options', 'hipsteria'),
    'post_types' => array('page'),
    'position' => 'normal', // normal, advanced, side
    'priority' => 'high', // high, core, default, low
    'sections' => $sections
  );
}


/**
 * Get configuration array for video post metaboxes
 * @return type
 */
function hipsteria_redux_get_video_post_metaboxes() {

  // Variable used to store the configuration array of sections
  $sections = array();

  // Metabox used to overwrite theme options by page
  require get_template_directory() . '/framework/admin/metaboxes/post-video.php';

  return array(
    'id' => 'hipsteria-video-post-options',
    'title' => esc_html__('Video Post Options', 'hipsteria'),
    'post_types' => array('post'),
    'position' => 'normal', // normal, advanced, side
    'priority' => 'high', // high, core, default, low
    'sections' => $sections,
    'post_format' => array('video')
  );
}

/**
 * Get configuration array for gallery post metaboxes
 * @return type
 */
function hipsteria_redux_get_gallery_post_metaboxes() {

  // Variable used to store the configuration array of sections
  $sections = array();

  // Metabox used to overwrite theme options by page
  require get_template_directory() . '/framework/admin/metaboxes/post-gallery.php';

  return array(
    'id' => 'hipsteria-gallery-post-options',
    'title' => esc_html__('Gallery Post Options', 'hipsteria'),
    'post_types' => array('post'),
    'position' => 'normal', // normal, advanced, side
    'priority' => 'high', // high, core, default, low
    'sections' => $sections,
    'post_format' => array('gallery')
  );
}

/**
 * Get configuration array for page metaboxes
 * @return type
 */
function hipsteria_redux_get_post_adv_metaboxes() {

  // Variable used to store the configuration array of sections
  $sections = array();

  // Metabox used to overwrite theme options by page
  require get_template_directory() . '/framework/admin/metaboxes/layout.php';

  return array(
    'id' => 'hipsteria-post-adv-options',
    'title' => esc_html__('Options', 'hipsteria'),
    'post_types' => array('post'),
    'position' => 'normal', // normal, advanced, side
    'priority' => 'high', // high, core, default, low
    'sections' => $sections
  );
}
