<?php
if (!class_exists('WP_List_Table')) {
  require_once(ABSPATH . 'wp-admin/includes/class-wp-list-table.php');
}
class RegistrationTable extends WP_List_Table
{

  /** Class constructor */
  public function __construct()
  {

    parent::__construct([
      'singular' => __('Booking', 'eventer'), //singular name of the listed records
      'plural' => __('Bookings', 'eventer'), //plural name of the listed records
      'ajax' => false //should this table support ajax?

    ]);
  }

   function extra_tablenav($which) {
      if ($which == 'top') {

        $specific_event = (isset($_REQUEST['eventer'])) ? $_REQUEST['eventer'] : '';
        $specific_event_date = (isset($_REQUEST['booking'])) ? $_REQUEST['booking'] : '';
        $event_booking_date = (isset($_REQUEST['booking'])) ? $_REQUEST['booking'] : '';

        ?>
          <div class="alignleft actions">
            <div class="alignleft actions">
              <label class="screen-reader-text" for="cat"><?php esc_html_e('Filter by event', 'eventer'); ?></label>
              <select name="eventer" class="postform">
                <option value=""><?php esc_html_e('All Events', 'eventer'); ?></option>
                <?php
                    $all_registered_events = array();
                $event_arg = array('post_type' => 'eventer', 'posts_per_page' => -1, 'orderby' => 'name', 'order' => 'ASC');
                $event_list = new WP_Query($event_arg);
                if ($event_list->have_posts()) : while ($event_list->have_posts()) : $event_list->the_post();
                    $all_registered_events[get_the_ID()] = get_the_title();
                  endwhile;
                endif;
                wp_reset_postdata();

                  // $order_recording_switch = eventer_get_settings('eventer_woo_orders');
                  $woocommerce_ticketing = eventer_get_settings('eventer_enable_woocommerce_ticketing');
                  foreach ($all_registered_events as $key => $value) {
                    $selected = ($specific_event == $key) ? 'selected' : '';
                    echo '<option ' . $selected . ' value="' . $key . '">' . $value . '</option>';
                  }
                        ?>
                </select>
                <input type="text" class="eventer-bookings-date" name="booking" value="<?php echo $event_booking_date; ?>" placeholder="<?php esc_html_e('Select Date', 'eventer'); ?>">
                 <input type="hidden" name="filter_eventer_bookings" value="1">
                 <input type="submit" class="button" id="filter_eventer_bookins" value="Filter">
              </div>
          </div>
        <?php
      }
   }

  /**
   * Retrieve customer’s data from the database
   *
   * @param int $per_page
   * @param int $page_number
   *
   * @return mixed
   */
  public static function get_customers($per_page = 10, $page_number = 1)
  {
    $offset = ($page_number - 1) * $per_page;
    $result = getRegistration(null, $per_page, $offset);
    return $result;
  }

  public static function get_filter_customers( $event_id ) {
    $ticket = getRegistrationTickets( $event_id, 10, 0, 'event_id' );

    if ( ! $ticket ) {
      return [];
    }

    $array = [];
    foreach ( $ticket as $key => $data ) {
      $result = getRegistration( $data->reg_id, 10, 1, 'id' );
      if ( ! $result ) {
        continue;
      }

      $array[] = get_object_vars( $result );
    }

    return $array;
  }

  /**
   * Returns the count of records in the database.
   *
   * @return null|string
   */
  public static function record_count()
  {
     $items = self::getBookings();

    return count( $items );
  }

  public static function getBookings() {
     global $wpdb;
	$table_name = $wpdb->prefix . "eventer_registration_tickets";
	$specific_event = (isset($_REQUEST['eventer'])) ? $_REQUEST['eventer'] : '';
	$bookings = (isset($_REQUEST['multipleslect'])) ? $_REQUEST['multipleslect'] : [];
	$specific_event_date = (isset($_REQUEST['booking'])) ? $_REQUEST['booking'] : '';
	$bookings_list = [];
	if ( $bookings ) {
		foreach ($bookings as $id) {
			if ( ! intval($id) ) {
				continue;
			}

			$bookings_list[] = $id;
		}
	}

	$where = "";
	if ( $specific_event != '') {
		$where = "WHERE event_id = '$specific_event'";
	}

	$wpdb->show_errors();
	$export_query = $wpdb->get_results("SELECT * FROM $table_name $where", ARRAY_A);

	if ( ! $export_query ) {
		return [];
	} else {

		$array_data = [];
		foreach ( $export_query as $key => $data ) {
			$result = getRegistration( $data['reg_id'], 10, 1, 'id' );
			if ( ! $result ) {
				continue;
			}

			if ( ! empty( $specific_event_date ) ) {
				$event_date = date( 'Y-m-d', strtotime( $result->reg_date ) );
				if ( $event_date !== $specific_event_date ) {
					continue;
				}
			}

			$array_data[] = get_object_vars( $result );
		}
	}

	return $array_data;
  }

  /** Text displayed when no customer data is available */
  public function no_items()
  {
    _e('No customers avaliable.', 'eventer');
  }

  /**
   * Method for name column
   *
   * @param array $item an array of DB data
   *
   * @return string
   */
  function column_name($item)
  {

    // create a nonce
    $delete_nonce = wp_create_nonce('sp_delete_customer');

    $title = '<strong>' . $item['id'] . '</strong>';

    $actions = [
      'delete' => sprintf('<a href="?page=%s&action=%s&customer=%s&_wpnonce=%s">Delete</a>', esc_attr($_REQUEST['page']), 'delete', absint($item['id']), $delete_nonce)
    ];

    return $title . $this->row_actions($actions);
  }

  /**
   * Render a column when no column specific method exists.
   *
   * @param array $item
   * @param string $column_name
   *
   * @return mixed
   */
  public function column_default($item, $column_name)
  {
    switch ($column_name) {
      case 'order_id':
        return '<a href="' . esc_url(get_admin_url() . 'admin.php?page=booking_details&booking_id=' . $item['id']) . '">' . $item['order_id'] . '</a>';
      case 'date':
        return $item['reg_date'];
      case 'mode':
        return $item['paymentmode'];
      case 'status':
        return $item['reg_status'];
      case 'amount':
        return $item['reg_amount'];
      default:
        return print_r($item, true); //Show the whole array for troubleshooting purposes
    }
  }

  /**
   * Render the bulk edit checkbox
   *
   * @param array $item
   *
   * @return string
   */
  function column_cb($item)
  {
    return sprintf(
      '<input type="checkbox" name="bulk-delete[]" value="%s" />',
      $item['id']
    );
  }

  /**
   * Associative array of columns
   *
   * @return array
   */
  function get_columns()
  {
    $columns = [
      'cb' => '<input type="checkbox" />',
      'order_id' => __('Order', 'eventer'),
      'date' => __('Date', 'eventer'),
      //'transaction' => __('Transaction', 'eventer'),
      'mode' => __('Mode', 'eventer'),
      'status' => __('Status', 'eventer'),
      'amount' => __('Amount', 'eventer')
    ];

    return $columns;
  }

  /**
   * Columns to make sortable.
   *
   * @return array
   */
  public function get_sortable_columns()
  {
    $sortable_columns = array(
      'date' => array('Date', true),
    );

    return $sortable_columns;
  }

  /**
   * Returns an associative array containing the bulk action
   *
   * @return array
   */
  public function get_bulk_actions()
  {
    $actions = [
      'bulk-delete' => 'Delete'
    ];

    return $actions;
  }

  /**
   * Handles data query and filter, sorting, and pagination.
   */
  public function prepare_items()
  {

    $this->_column_headers = $this->get_column_info();

    /** Process bulk action */
    $this->process_bulk_action();

    $per_page = $this->get_items_per_page('customers_per_page', 5);
    $current_page = $this->get_pagenum();
    $total_items = self::record_count();

    $this->set_pagination_args([
      'total_items' => $total_items, //WE have to calculate the total number of items
      'per_page' => $per_page //WE have to determine how many items to show on a page
    ]);

    $this->items = self::getBookings();
  }

  public function process_bulk_action()
  {

    //Detect when a bulk action is being triggered...
    if ('delete' === $this->current_action()) {

      // In our file that handles the request, verify the nonce.
      $nonce = esc_attr($_REQUEST['_wpnonce']);

      if (!wp_verify_nonce($nonce, 'sp_delete_customer')) {
        die('Go get a life script kiddies');
      } else {
        self::delete_customer(absint($_GET['customer']));

        wp_redirect(esc_url(add_query_arg()));
        exit;
      }
    }

    // If the delete bulk action is triggered
    if ((isset($_POST['action']) && $_POST['action'] == 'bulk-delete')
      || (isset($_POST['action2']) && $_POST['action2'] == 'bulk-delete')
    ) {

      $delete_ids = esc_sql($_POST['bulk-delete']);

      // loop over the array of record IDs and delete them
      foreach ($delete_ids as $id) {
        self::delete_customer($id);
      }

      wp_redirect(esc_url(add_query_arg()));
      exit;
    }
  }
  public function delete_customer($id)
  {
    global $wpdb;
    $table_name = $wpdb->prefix . "eventer_registrations";
    $wpdb->delete($table_name, array('id' => $id));
  }
}

