<?php
class Bookings
{

  // class instance
  static $instance;

  // customer WP_List_Table object
  public $customers_obj;

  // class constructor
  public function __construct()
  {
    add_filter('set-screen-option', [__CLASS__, 'set_screen'], 10, 3);
    add_action('admin_menu', [$this, 'plugin_menu']);
    add_action('admin_menu', [$this, 'bookingDetails']);
	add_action('wp_ajax_eventer_export_bookings', [ $this, 'eventer_export_bookings' ] );

  }

  public function eventer_export_bookings() {

		global $wpdb;
		$table_name = $wpdb->prefix . "eventer_registration_tickets";
		$specific_event = (isset($_REQUEST['eventer'])) ? $_REQUEST['eventer'] : '';
		$bookings = (isset($_REQUEST['multipleslect'])) ? $_REQUEST['multipleslect'] : [];
		$specific_event_date = (isset($_REQUEST['booking_date'])) ? $_REQUEST['booking_date'] : '';
		$bookings_list = [];
		if ( $bookings ) {
			foreach ($bookings as $id) {
				if ( ! intval($id) ) {
					continue;
				}

				$bookings_list[] = $id;
			}
		}

		$where = "";
		if ( $specific_event != '') {
			$where = "WHERE event_id = '$specific_event'";
		}

		if ( ! empty( $bookings_list ) ) {
			$id_string = implode(',', $bookings_list); 
			$where .= "WHERE reg_id IN ($id_string)";
		}

		$wpdb->show_errors();
		$file = 'eventer_booking_csv';
		$export_query = $wpdb->get_results("SELECT * FROM $table_name $where", ARRAY_A);

		if ( ! $export_query ) {
			$Error = $wpdb->print_error();
			die("The following error was found: $Error");
		} else {

			$array_data = [];
			foreach ( $export_query as $key => $data ) {
				$result = getRegistration( $data['reg_id'], 10, 1, 'id' );
				if ( ! $result ) {
					continue;
				}

				if ( ! empty( $specific_event_date ) ) {
					$event_date = date( 'Y-m-d', strtotime( $result->reg_date ) );
					if ( $event_date !== $specific_event_date ) {
						continue;
					}
				}

				$array_data[] = get_object_vars( $result );
			}

			$csv_fields = array();
			$output_filename = $file . "_" . date_i18n("Y-m-d_H-i-s") . ".csv";
			$output_handle = @fopen('php://output', 'w');

			header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
			header('Content-Description: File Transfer');
			header('Content-type: text/csv');
			header('Content-Disposition: attachment; filename=' . $output_filename);
			header('Expires: 0');
			header('Pragma: public');
			$leadArray = $new_rows = $user_data_set = array();

			$csv_fields[] = 'booking id';
			$csv_fields[] = 'Status';
			$csv_fields[] = 'User ID';
			$csv_fields[] = 'order id';
			$csv_fields[] = 'Booking Date';
			$csv_fields[] = 'Payment Mode';
			$csv_fields[] = 'Amount';
			$csv_fields[] = 'Event Title';
			$csv_fields[] = 'Event Date';
			$csv_fields[] = 'Name';
			$csv_fields[] = 'Email';
			$csv_fields[] = 'Phone';
			$csv_fields[] = 'Ticket name';

			fputcsv($output_handle, $csv_fields);

			foreach ($array_data as $Result) {
				if ($booking_status != '') {
					if ($booking_status != $Result['status']) continue;
				}

				$woo_order = $Result['order_id'];
				$order = wc_get_order($woo_order);
				
				if (!$order) continue;

				foreach ($order->get_items() as $item_key => $item_values) :
					$data_set = array();
					$item_data = $item_values->get_data();
					$item_id = $item_values->get_id();
					$product_name = $item_data['name'];
					$product_id = $item_data['product_id'];
					$quantity = $item_data['quantity'];
					$order_event_url = wc_get_order_item_meta($item_id, 'Event URL', true);
					$eventer_id = wc_get_order_item_meta($item_id, '_wceventer_id', true);
					$eventer_date = wc_get_order_item_meta($item_id, '_wceventer_date', true);

					$data_set['booking id'] = $Result['id'];
					$data_set['status'] = $Result['reg_status'];
					$data_set['User ID'] = $Result['user_id'];
					$data_set['order id'] = $woo_order;
					$data_set['Booking Date'] = date_i18n(get_option('date_format') . ' ' . get_option('time_format'), strtotime($Result['reg_date']));
					$data_set['Payment Mode'] = $Result['paymentmode'];
					$data_set['Amount'] = $Result['reg_amount'];
					$data_set['Event Title'] = get_the_title($eventer_id);
					$data_set['Event Date'] = date_i18n(get_option('date_format'), strtotime($eventer_date));
					$data_set['Name'] = get_post_meta($woo_order, '_billing_first_name', true) . ' ' . get_post_meta($woo_order, '_billing_last_name', true);
					$data_set['Email'] = get_post_meta($woo_order, '_billing_email', true);
					$data_set['Phone'] = get_post_meta($woo_order, '_billing_phone', true);
					$data_set['Ticket name'] = $product_name;
					fputcsv($output_handle, $data_set);

				endforeach;
			}

			fclose($output_handle);
		}
		die();
	}

  public static function set_screen($status, $option, $value)
  {
    return $value;
  }

  public function plugin_menu()
  {
    $hook = add_menu_page(
      'New Bookings',
      'New Bookings',
      'manage_options',
      'eventer_bookings',
      [$this, 'plugin_settings_page']
    );

    add_action("load-$hook", [$this, 'screen_option']);
  }

  public function bookingDetails()
  {

    $hook = add_menu_page(
      'Booking Details',
      'Booking Details',
      'manage_options',
      'booking_details',
      [$this, 'bookingDetailsPage'],
    );

    add_action("load-$hook", [$this, 'screen_option']);
  }

  /**
   * Screen options
   */
  public function screen_option()
  {

    $option = 'per_page';
    $args = [
      'label' => 'Customers',
      'default' => 20,
      'option' => 'customers_per_page'
    ];

    add_screen_option($option, $args);

    $this->customers_obj = new RegistrationTable();
  }

  /**
   * Plugin settings page
   */
  public function plugin_settings_page()
  {
	$reg_details = $this->getBookings();

	?>
	<div class="wrap">
	  <h2>Eventer Bookings</h2>
	  <?php if (!empty($reg_details)) : ?>
		<form class="test-form" action="<?php echo esc_url(admin_url('admin-ajax.php')); ?>" method="post">
		<input type="hidden" name="action" value="eventer_export_bookings">
		<input type="hidden" name="date" value="<?php echo (isset($_REQUEST['booking'])) ? $_REQUEST['booking'] : ''; ?>">
		<input type="hidden" name="eventer" value="<?php echo (isset($_REQUEST['eventer'])) ? $_REQUEST['eventer'] : ''; ?>">
		<input type="hidden" name="eventer_all" value="<?php echo (isset($_REQUEST['eventer_id'])) ? $_REQUEST['eventer_id'] : ''; ?>">
		<input type="submit" value="<?php esc_html_e('Download csv', 'eventer'); ?>" class="button eventer-download-bulk-downloading">
		</form>
	  <?php endif; ?>

	  <div id="poststuff">
		<div id="post-body" class="metabox-holder">
		  <div id="post-body-content">
			<div class="meta-box-sortables ui-sortable">
			  <form class="form-eventer_bookins" action="<?php echo esc_url(admin_url('admin.php?page=eventer_bookings')); ?>" method="post">
				<?php
					$this->customers_obj->prepare_items();
					$this->customers_obj->display(); ?>
			  </form>
			</div>
		  </div>
		</div>
		<br class="clear">
	  </div>
	</div>
<?php
  }

  public function getBookings() {

  	global $wpdb;
	$table_name = $wpdb->prefix . "eventer_registration_tickets";
	$specific_event = (isset($_REQUEST['eventer'])) ? $_REQUEST['eventer'] : '';
	$bookings = (isset($_REQUEST['multipleslect'])) ? $_REQUEST['multipleslect'] : [];
	$specific_event_date = (isset($_REQUEST['booking'])) ? $_REQUEST['booking'] : '';
	$bookings_list = [];
	if ( $bookings ) {
		foreach ($bookings as $id) {
			if ( ! intval($id) ) {
				continue;
			}

			$bookings_list[] = $id;
		}
	}

	$where = "";
	if ( $specific_event != '') {
		$where = "WHERE event_id = '$specific_event'";
	}

	$wpdb->show_errors();
	$export_query = $wpdb->get_results("SELECT * FROM $table_name $where", ARRAY_A);

	if ( ! $export_query ) {
		return [];
	} else {

		$array_data = [];
		foreach ( $export_query as $key => $data ) {
			$result = getRegistration( $data['reg_id'], 10, 1, 'id' );
			if ( ! $result ) {
				continue;
			}

			if ( ! empty( $specific_event_date ) ) {
				$event_date = date( 'Y-m-d', strtotime( $result->reg_date ) );
				if ( $event_date !== $specific_event_date ) {
					continue;
				}
			}

			$array_data[] = get_object_vars( $result );
		}
	}

	return $array_data;
  }

  /**
   * Plugin settings page
   */
  public function bookingDetailsPage()
  {
    $bookingId = isset($_REQUEST['booking_id']) ? $_REQUEST['booking_id'] : '';
    $bookingDetails = getRegistration($bookingId);
    $bookingTickets = getRegistrationTickets($bookingId);
    eventer_append_template_with_arguments('eventers/admin/booking', "details", ['booking' => (array) $bookingDetails, 'tickets' => $bookingTickets]);
  }

  /** Singleton instance */
  public static function get_instance()
  {
    if (!isset(self::$instance)) {
      self::$instance = new self();
    }

    return self::$instance;
  }
}
add_action('plugins_loaded', function () {
  Bookings::get_instance();
});
