<?php
/*
 * Plugin Name: Eventer
 * Plugin URI:  https://eventer.imithemes.com
 * Description: WordPress Event Manager Plugin
 * Author:      imithemes
 * Version:     3.7.4.1
 * Author URI:  http://www.imithemes.com
 * Licence:     GPLv2
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 * Copyright:   (c) 2023 imithemes. All rights reserved
 * Text Domain: eventer
 * Domain Path: /languages
 */

// Do not allow direct access to this file.
defined('ABSPATH') or die('No script kiddies please!');

define('EVENTER__PLUGIN_PATH', plugin_dir_path(__FILE__));
define('EVENTER__PLUGIN_URL', plugin_dir_url(__FILE__));
/* PARTIALS ATTACHMENTS
================================================== */
require_once EVENTER__PLUGIN_PATH . '/admin/admin_functions.php';
require_once EVENTER__PLUGIN_PATH . '/admin/eventer-type.php';
require_once EVENTER__PLUGIN_PATH . '/admin/settings_page.php';
require_once EVENTER__PLUGIN_PATH . '/admin/meta_fields.php';
if (!is_admin()) {
    require_once EVENTER__PLUGIN_PATH . '/front/eventer-shortcodes.php';

}
require_once EVENTER__PLUGIN_PATH . '/front/front_functions.php';
require_once EVENTER__PLUGIN_PATH . '/front/eventer_rest_endpoints.php';
require_once EVENTER__PLUGIN_PATH . '/front/eventer_rest_endpoints_v2.php';
require_once EVENTER__PLUGIN_PATH . '/front/eventer_actions.php';

require_once EVENTER__PLUGIN_PATH . '/front/shortcodes.php';
require_once EVENTER__PLUGIN_PATH . '/front/ipn.php';
require_once EVENTER__PLUGIN_PATH . 'WC/WC.php';
require_once EVENTER__PLUGIN_PATH . '/VC/VC.php';

/* SET LANGUAGE FILE FOLDER
=================================================== */
add_action('plugins_loaded', 'eventer_load_textdomain');
function eventer_load_textdomain()
{
    load_plugin_textdomain('eventer', false, basename(dirname(__FILE__)) . '/languages');
    $site_lang = substr(get_locale(), 0, 2);
    if (function_exists('icl_object_id') && class_exists('SitePress')) {
        $site_lang = ICL_LANGUAGE_CODE;
    }
    define('EVENTER__LANGUAGE_CODE', $site_lang);
    $woocommerce_switch = eventer_get_settings('eventer_enable_woocommerce_ticketing');
    $woocommerce_layout = eventer_get_settings('eventer_woo_layout');
    $eventer_slug = eventer_get_settings('eventer_event_permalink');
    $event_slug = (empty($eventer_slug)) ? 'eventer' : $eventer_slug;
    $event_link = $_SERVER['REQUEST_URI'];
    if ($woocommerce_switch == 'on' && $woocommerce_layout == 'on' && !defined('WOOCOMMERCE_CHECKOUT') && strpos($event_link, $event_slug)) {
        define('WOOCOMMERCE_CHECKOUT', true);
    }
}

/* GETTING EVENTER SETTING PAGE ID
=================================================== */
function eventer_get_settings($id)
{
    $options = get_option('eventer_options');
    if (isset($options[$id])) {
        return $options[$id];
    }
}

register_activation_hook(__FILE__, 'imi_redirect_after_activation');

function imi_redirect_after_activation() {
    add_option('redirect_eventer_activation', true);
}

add_action('admin_init', 'imi_activation_redirect');

function imi_activation_redirect() {
    if (get_option('redirect_eventer_activation', false)) {
        delete_option('redirect_eventer_activation');
        exit(wp_redirect(admin_url( 'edit.php?post_type=eventer&page=eventer-license' )));
    }
}

add_action('admin_menu', 'eventer_register_license_page');
function eventer_register_license_page() {
    add_submenu_page(
        'edit.php?post_type=eventer',
        __( 'License', 'eventer' ),
        __( 'License', 'eventer' ),
        'manage_options',
        'eventer-license',
        'eventer_license_callback'
    );
}
function disallowed_eventer_admin_pages()
  {
    global $pagenow;
    if ($pagenow == 'edit.php') {
      $domain = preg_replace( '|https?://([^/]+)|', '$1', home_url() );
      $localhost = false;
      if ( parse_url( home_url() , PHP_URL_PATH ) || 'localhost' === $domain || preg_match( '|^[0-9]+\.[0-9]+\.[0-9]+\.[0-9]+$|', $domain ) ) {
        $localhost = true;
      }
      if (!$localhost && (!empty($_REQUEST['page']) && $_REQUEST['page'] == 'eventer_settings_options')) {
        if (empty(get_option('eventer_authenticate'))) {
          wp_safe_redirect(admin_url('edit.php?post_type=eventer&page=eventer-license'));
          exit;
        }
      }
    }
  }
  add_action('admin_init', 'disallowed_eventer_admin_pages');

  function eventerProcessAuthentication()
  {
    $status = $_REQUEST['status'];
    $authCode = $_REQUEST['authCode'];
    update_option('eventer_authenticate', $status);
    update_option('eventer_auth_code', $authCode);
    wp_die();
  }
  add_action('wp_ajax_eventerProcessAuthentication', 'eventerProcessAuthentication');

/**
 * Display callback for the submenu page.
 */
function eventer_license_callback() { 
    ?>
    <div class="wrap about-wrap">
		<h1><?php esc_html_e('License Activation','eventer'); ?></h1>
		<div class="imi-box-content">
			<p>
				<?php echo esc_html__('Thank you for choosing Eventer! Please register it to get access to all the features & settings. The instructions below must be followed exactly to successfully register your purchase.', 'eventer'); ?>
			</p>
			<div class="eventer-activate"></div>
						</div>
  <?php 

	$purchaseCode = $purchaseCodeRaw = $showRegisterForm = "";
	$showUnRegisterForm = ' style="display: none;"';
	if(!empty(get_option('eventer_auth_code'))) {
		$purchaseCode = "xxxxxx-xxxx-xxxxxxx-xxxxx".substr(get_option('eventer_auth_code'), -4);
		$purchaseCodeRaw = get_option('eventer_auth_code');
		$showRegisterForm = ' style="display: none;"';
		$showUnRegisterForm = "";
	}
	?>
	<div class="eventer-validation-steps">
		<div class="imi-box-content imi-theme-reg-box" <?php echo ''.$showUnRegisterForm; ?>>
			<h3 style="color: green; text-align: left">Plugin is active</h3>
		</div>
		<div class="imi-box-content imi-theme-reg-box" <?php echo ''.$showRegisterForm; ?>>
				<h3 style="color: red; text-align: left">Please activate your Eventer purchase code</h3>
		</div>
		<div class="imi-box-content">
			<form class="imi_eventer_val" <?php echo ''.$showRegisterForm; ?>>
				<label for="imi_purchase_code"><?php esc_html_e('Purchase Code: ','framework') ?></label>
				<input type="text" value="" class="eventer-purchase-code">
				<input type="hidden" value="<?php echo urlencode(site_url()); ?>" class="eventer-verified-dm">
				<input type="hidden" value="<?php echo esc_url($_SERVER['REMOTE_ADDR']); ?>" class="eventer-server-type">
				<input type="submit" value="Register">
			<div class="eventer-message"></div>
			</form>

			<form class="imi_eventer_vals" <?php echo ''.$showUnRegisterForm; ?>>
				<label for="imi_purchase_code"><?php esc_html_e('Purchase Code: ','framework') ?></label>
				<input type="text" class="eventer-hidden-code" value="<?php echo esc_attr($purchaseCode); ?>">
				<input type="hidden" value="<?php echo urlencode(site_url()) ?>" class="eventer-verified-dm">
				<input type="hidden" value="<?php echo esc_url($_SERVER['REMOTE_ADDR']); ?>" class="eventer-server-type">
				<input type="hidden" value="<?php echo esc_attr($purchaseCodeRaw); ?>" class="eventer-purchase-code">
				<input type="submit" value="Unregister">
				<p><small>Unregister the purchase code to use it on any other domain/website.</small></p>
			<div class="eventer-message"></div>
			</form>

			<div <?php echo ''.$showRegisterForm; ?>>
				<h3><?php _e( 'Instructions for registering your purchase code', 'framework' ); ?></h3>
				<p>Whenever you purchase an item via the Codecanyon, they will provide you with a purchase code for each item purchased. The purchase code is used for purchase validation for use of the item and also so that you can access the support.</p>
				<ol>
					<li>Log in to Codecanyon with your Envato account.</li>
					<li>Navigate to the Downloads tab. Your all purchases and items appear in this page.</li>
					<li>Locate your item, and click the Download button.</li>
					<li>Choose between License Certificate &amp; Purchase Code (PDF) or License Certificate &amp; Purchase Code (Text).</li>
					<li>Open the file to find the purchase code.</li>
				</ol>
				<p><a href="https://www.youtube.com/watch?v=yTScONNFnZ8" target="_blank">See instructions video</a></p>
			</div>
		</div>
	</div>
    <?php
}
/* EVENTER DATE DIFFERENCE FUNCTION
=================================================== */
if (!function_exists('eventer_dateDiff')) {
    function eventer_dateDiff($start, $end)
    {
        $start_ts = strtotime($start);
        $end_ts = strtotime($end);
        $diff = $end_ts - $start_ts;
        return floor($diff / 86400);
    }
}
// User Roles
function eventer_add_eventer_manager_role()
{
    add_role('eventer_manager', esc_html__('Event manager', 'eventer'), array('edit_post' => true, 'edit_published_posts' => true, 'edit_posts' => true, 'publish_posts' => true, 'read_post' => true, 'read' => true, 'delete_post' => true, 'edit_published_posts' => true, 'upload_files' => true, 'edit_product' => true, 'edit_published_products' => true, 'edit_products' => true, 'publish_products' => true, 'read_product' => true, 'delete_product' => true));
}
// Elementor Widget
// Custom Elementor Widgets Registration
function register_eventer_elementor_widget( $widgets_manager ) {

	require_once(EVENTER__PLUGIN_PATH . '/elementor/class-eventer.php');
	$widgets_manager->register( new \Elementor_Eventer_Widget() );

}
add_action( 'elementor/widgets/register', 'register_eventer_elementor_widget' );
/* PLUGIN ACTIVATION HOOK
=================================================== */
register_activation_hook(__FILE__, 'eventer_add_eventer_manager_role');
add_action('admin_init', array('Eventer_Settings_Options', 'eventer_create_ticket_details_table'));
register_activation_hook(__FILE__, array('Eventer_Settings_Options', 'eventer_flush_rewrite_activate'));
register_activation_hook(__FILE__, array('Eventer_Settings_Options', 'eventer_flush_rewrite_deactivate'));
register_activation_hook(__FILE__, array('Eventer_Settings_Options', 'eventer_store_default_settings'));
