<?php
/*
 * General Section
*/

$this->sections[] = array(
	'title' => esc_html__('General Settings', 'hipsteria'),
	'desc' => esc_html__('Configure easily the basic theme\'s settings.', 'hipsteria'),
	'icon' => 'el-icon-adjust-alt',
	'fields' => array(

	),
);

$this->sections[] = array(
  'title' => esc_html__('General', 'hipsteria'),
  'desc' => esc_html__('Configure general styles.', 'hipsteria'),
  'subsection' => true,
  'fields'  => array(
    array(
      'id'       => 'general-pagination',
      'type'     => 'select',
      'title'    => esc_html__('Pagination', 'hipsteria'),
      'subtitle' => esc_html__('Choose template for footer.', 'hipsteria'),
      'options'  => array(
        'standard'  => esc_html__('Standard','hipsteria'),
        'load-more' => esc_html__('Load More','hipsteria'),
      ),
      'default' => 'standard',
      'validate' => 'not_empty',
    ),
    array(
      'id'       => 'general-home-layout',
      'type'     => 'select',
      'title'    => esc_html__('Home Page', 'hipsteria'),
      'subtitle' => esc_html__('Choose template for homepage.', 'hipsteria'),
      'options'  => array(
        'list' => esc_html__('List','hipsteria'),
        'grid'  => esc_html__('Grid','hipsteria'),
      ),
      'default' => 'list',
      'validate' => 'not_empty',
    ),
    array(
      'id'       =>'general-logo',
      'type'     => 'media',
      'url'      => true,
      'title'    => esc_html__('Logo', 'hipsteria'),
      'subtitle' => esc_html__('Upload the logo that will be displayed in the header.', 'hipsteria'),
    ),
    array(
      'id'       =>'general-sticky-logo',
      'type'     => 'media',
      'url'      => true,
      'title'    => esc_html__('Sticky Logo', 'hipsteria'),
      'subtitle' => esc_html__('Upload sticky logo for header.', 'hipsteria'),
    ),
    array(
      'id'       =>'general-excerpt',
      'type'     => 'text',
      'title'    => esc_html__('Home Excerpt Length', 'hipsteria'),
    ),
    array(
      'id'       => 'custom-sidebars',
      'type'     => 'multi_text',
      'title'    => esc_html__( 'Custom Sidebars', 'hipsteria' ),
      'subtitle' => esc_html__( 'Custom sidebars can be assigned to any page or post.', 'hipsteria' ),
      'desc'     => esc_html__( 'You can add as many custom sidebars as you need.', 'hipsteria' )
    ),
    array(
      'id'       => 'general-open-post',
      'type'     => 'switch',
      'title'    => esc_html__('Open Post In New Window', 'hipsteria'),
      'subtitle' => esc_html__('If on, post will be displayed in new window.', 'hipsteria'),
      'default'  => 1,
    ),
  ),
);

$this->sections[] = array(
  'title' => esc_html__('Navigation', 'hipsteria'),
  'desc' => esc_html__('Configure menu styles.', 'hipsteria'),
  'subsection' => true,
  'fields'  => array(
    array(
      'id'       => 'general-navigation-template',
      'type'     => 'select',
      'title'    => esc_html__('Template', 'hipsteria'),
      'subtitle' => esc_html__('Choose template for menu.', 'hipsteria'),
      'options'  => array(
        'sticky-nav-on enable' => esc_html__('Sticky','hipsteria'),
        'fixed'         => esc_html__('Fixed','hipsteria'),
      ),
      'default' => 'sticky-nav-on',
      'validate' => 'not_empty',
    ),
    array(
      'id'       => 'general-social',
      'type'     => 'switch',
      'title'    => esc_html__('Social Icons', 'hipsteria'),
      'subtitle' => esc_html__('If on, social icons will be displayed.', 'hipsteria'),
      'default'  => 1,
    ),
  ),
);

$this->sections[] = array(
  'title' => esc_html__('Post Meta Data Settings', 'hipsteria'),
  'desc' => esc_html__('Show/Hide Post meta data', 'hipsteria'),
  'subsection' => true,
  'fields'  => array(

    array(
      'id'       => 'meta-date',
      'type'     => 'switch',
      'title'    => esc_html__('show date', 'hipsteria'),
      'subtitle' => esc_html__('If on, date will be displayed.', 'hipsteria'),
      'default'  => 1,
    ),
    array(
      'id'       => 'meta-views-count',
      'type'     => 'switch',
      'title'    => esc_html__('show views count', 'hipsteria'),
      'subtitle' => esc_html__('If on, views count will be displayed.', 'hipsteria'),
      'default'  => 1,
    ),
    array(
      'id'       => 'meta-comment-count',
      'type'     => 'switch',
      'title'    => esc_html__('show comment count', 'hipsteria'),
      'subtitle' => esc_html__('If on, comment count will be displayed', 'hipsteria'),
      'default'  => 1,
    ),
  ),
);




